# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 3
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR3_strategy.txt
# LLM Suggested Fallback: C

def radiant_mirage(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    # Analyze opponent's code for static strategies
    always_defect = "return 'D'" in opponent_program_code.replace(" ", "")
    always_cooperate = "return 'C'" in opponent_program_code.replace(" ", "")
    if always_defect:
        return "C"
    if always_cooperate:
        return "D"
    
    # Check for Tit-for-Tat-like behavior
    tit_for_tat = "opp_history[-1]" in opponent_program_code.replace(" ", "")
    if tit_for_tat:
        if len(my_history) % 3 == 0:
            return "D"
        return opp_history[-1]
    
    # Default behavior: Tit-for-Tat with occasional testing defections
    if len(my_history) >= 3 and all(m == "C" for m in opp_history[-3:]):
        if random.random() < 0.2:
            return "D"
    
    if len(my_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
        if random.random() < 0.1:
            return "C"
    
    if len(my_history) >= 9:
        return "D"
    
    return opp_history[-1] if opp_history else "C"